<h2 class="mb-3">Tentang Saya</h2>

<div class="row mb-4">
  <div class="col-md-4">
    <?php if(!empty($about->hero_image)): ?>
      <img class="img-fluid rounded border" src="<?= base_url('assets/img/about/'.$about->hero_image); ?>" alt="Foto">
    <?php else: ?>
      <div class="border rounded p-5 text-center text-muted">Belum ada foto</div>
    <?php endif; ?>
  </div>
  <div class="col-md-8">
    <div class="mb-3"><?= nl2br(html_escape($about->content)); ?></div>
    <div class="row">
      <div class="col-md-6">
        <div class="card h-100">
          <div class="card-body">
            <h6 class="text-muted">Alamat</h6>
            <div><?= nl2br(html_escape($about->address)); ?></div>
          </div>
        </div>
      </div>
      <div class="col-md-6 mt-3 mt-md-0">
        <div class="card h-100">
          <div class="card-body">
            <h6 class="text-muted">Nomor Telepon</h6>
            <div><?= html_escape($about->phone); ?></div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<h4 class="mb-3">Galeri</h4>
<?php if(empty($gallery)): ?>
  <div class="text-muted">Belum ada foto galeri.</div>
<?php else: ?>
  <div class="row g-3">
    <?php foreach($gallery as $g): ?>
      <div class="col-6 col-md-3">
        <img class="img-fluid rounded" style="height:180px;object-fit:cover"
             src="<?= base_url('assets/img/about/'.html_escape($g->image)); ?>" alt="">
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
