<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <title><?= isset($title)?$title.' | ':'' ?>Aquarium Tics</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="<?= base_url('assets/css/style.css'); ?>" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  
  <style>
    :root {
      --ocean-blue: #0077be;
      --aqua-green: #00bfa5;
      --deep-blue: #004d7a;
      --light-blue: #e0f7fa;
      --coral: #ff6b6b;
      --white: #ffffff;
    }

    body {
      background: linear-gradient(180deg, #e0f7fa 0%, #ffffff 100%);
      min-height: 100vh;
      position: relative;
      overflow-x: hidden;
    }

    /* Animated Ocean Background */
    body::before {
      content: '';
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: 
        radial-gradient(circle at 20% 80%, rgba(0, 191, 165, 0.1) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(0, 119, 190, 0.1) 0%, transparent 50%);
      pointer-events: none;
      z-index: 0;
    }

    /* Navbar Styling */
    .navbar {
      background: rgba(255, 255, 255, 0.95) !important;
      backdrop-filter: blur(10px);
      box-shadow: 0 5px 20px rgba(0, 119, 190, 0.1);
      border: none !important;
      padding: 1rem 0;
      position: sticky;
      top: 0;
      z-index: 1030;
      transition: all 0.3s ease;
    }

    .navbar.scrolled {
      padding: 0.5rem 0;
      box-shadow: 0 8px 30px rgba(0, 119, 190, 0.15);
    }

    .navbar-brand {
      font-size: 1.5rem;
      font-weight: 800;
      background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
      letter-spacing: 0.5px;
      position: relative;
      transition: transform 0.3s ease;
    }

    .navbar-brand:hover {
      transform: scale(1.05);
    }

    .navbar-brand::before {
      content: '🐠';
      position: absolute;
      left: -30px;
      animation: swimBrand 2s ease-in-out infinite;
    }

    @keyframes swimBrand {
      0%, 100% { transform: translateY(0); }
      50% { transform: translateY(-5px); }
    }

    .nav-link {
      color: var(--deep-blue) !important;
      font-weight: 600;
      padding: 0.5rem 1.2rem !important;
      margin: 0 0.2rem;
      border-radius: 25px;
      transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      position: relative;
      overflow: hidden;
    }

    .nav-link::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
      transition: left 0.3s ease;
      z-index: -1;
      border-radius: 25px;
    }

    .nav-link:hover {
      color: white !important;
      transform: translateY(-2px);
    }

    .nav-link:hover::before {
      left: 0;
    }

    .nav-link.active {
      background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
      color: white !important;
      box-shadow: 0 5px 15px rgba(0, 119, 190, 0.3);
    }

    /* Navbar Toggler */
    .navbar-toggler {
      border: 2px solid var(--aqua-green);
      border-radius: 10px;
      padding: 0.5rem 0.75rem;
    }

    .navbar-toggler:focus {
      box-shadow: 0 0 0 0.25rem rgba(0, 191, 165, 0.25);
    }

    .navbar-toggler-icon {
      background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 30 30'%3e%3cpath stroke='rgba(0, 119, 190, 1)' stroke-linecap='round' stroke-miterlimit='10' stroke-width='2' d='M4 7h22M4 15h22M4 23h22'/%3e%3c/svg%3e");
    }

    /* Main Content Area */
    main {
      position: relative;
      z-index: 1;
      min-height: calc(100vh - 80px);
    }

    .container {
      position: relative;
      z-index: 2;
    }

    /* Bubbles Animation */
    .bubbles-container {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      pointer-events: none;
      z-index: 1;
      overflow: hidden;
    }

    .bubble {
      position: absolute;
      bottom: -100px;
      background: radial-gradient(circle at 30% 30%, rgba(255, 255, 255, 0.8), rgba(0, 191, 165, 0.4));
      border-radius: 50%;
      opacity: 0.6;
      animation: rise linear infinite;
      box-shadow: inset 0 0 10px rgba(255, 255, 255, 0.5),
                  0 0 20px rgba(0, 191, 165, 0.3);
    }

    .bubble::before {
      content: '';
      position: absolute;
      top: 10%;
      left: 15%;
      width: 30%;
      height: 30%;
      background: rgba(255, 255, 255, 0.6);
      border-radius: 50%;
      filter: blur(2px);
    }

    @keyframes rise {
      0% {
        bottom: -100px;
        transform: translateX(0) scale(1);
        opacity: 0;
      }
      10% {
        opacity: 0.6;
      }
      50% {
        transform: translateX(20px) scale(1.1);
      }
      90% {
        opacity: 0.6;
      }
      100% {
        bottom: 110vh;
        transform: translateX(-20px) scale(0.8);
        opacity: 0;
      }
    }

    /* Fish Swimming Animation */
    .fish-decoration {
      position: fixed;
      font-size: 2rem;
      pointer-events: none;
      z-index: 1;
      animation: swimAcross 15s linear infinite;
      opacity: 0.4;
    }

    .fish-decoration:nth-child(2) {
      animation-delay: 5s;
      top: 30%;
    }

    .fish-decoration:nth-child(3) {
      animation-delay: 10s;
      top: 60%;
      animation-duration: 20s;
    }

    @keyframes swimAcross {
      0% {
        left: -100px;
        transform: scaleX(1);
      }
      45% {
        left: 50%;
        transform: scaleX(1);
      }
      50% {
        left: 50%;
        transform: scaleX(-1);
      }
      100% {
        left: 110%;
        transform: scaleX(-1);
      }
    }

    /* Responsive */
    @media (max-width: 991px) {
      .navbar-collapse {
        background: rgba(255, 255, 255, 0.98);
        padding: 1rem;
        border-radius: 15px;
        margin-top: 1rem;
        box-shadow: 0 10px 30px rgba(0, 119, 190, 0.1);
      }

      .nav-link {
        margin: 0.3rem 0;
      }

      .navbar-brand::before {
        left: -25px;
      }
    }

    @media (max-width: 576px) {
      .navbar-brand {
        font-size: 1.2rem;
      }

      .navbar-brand::before {
        font-size: 1rem;
        left: -22px;
      }
    }
  </style>
</head>
<body>

<!-- Bubbles Background -->
<div class="bubbles-container" id="bubblesContainer"></div>

<!-- Swimming Fish Decorations -->
<div class="fish-decoration" style="top: 20%;">🐟</div>
<div class="fish-decoration" style="top: 40%;">🐠</div>
<div class="fish-decoration" style="top: 70%;">🐡</div>

<nav class="navbar navbar-expand-lg navbar-light">
  <div class="container">
    <a class="navbar-brand" href="<?= base_url(); ?>">Aquarium Paradise</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#nav" 
            aria-controls="nav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div id="nav" class="collapse navbar-collapse">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item">
          <a class="nav-link <?= uri_string() == '' ? 'active' : '' ?>" href="<?= base_url(); ?>">
            Home
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link <?= uri_string() == 'admin/about' ? 'active' : '' ?>" 
             href="<?= site_url('tentang'); ?>">
            Tentang
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link <?= uri_string() == 'produk' ? 'active' : '' ?>" 
             href="<?= site_url('produk'); ?>">
            Produk
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link <?= uri_string() == 'kontak' ? 'active' : '' ?>" 
             href="<?= site_url('kontak'); ?>">
            Kontak
          </a>
        </li>
        <li class="nav-item">
          <a class="nav-link <?= uri_string() == 'admin/login' ? 'active' : '' ?>" 
             href="<?= site_url('admin/login'); ?>">
            Admin
          </a>
        </li>
      </ul>
    </div>
  </div>
</nav>

<main class="py-5">
<div class="container">

<script>
// Generate bubbles
function createBubbles() {
  const container = document.getElementById('bubblesContainer');
  const bubbleCount = 25;
  
  for (let i = 0; i < bubbleCount; i++) {
    const bubble = document.createElement('div');
    bubble.className = 'bubble';
    
    const size = Math.random() * 50 + 10;
    bubble.style.width = size + 'px';
    bubble.style.height = size + 'px';
    bubble.style.left = Math.random() * 100 + '%';
    
    const duration = (size / 10) + 8 + Math.random() * 5;
    bubble.style.animationDuration = duration + 's';
    bubble.style.animationDelay = Math.random() * 5 + 's';
    
    container.appendChild(bubble);
  }
}

// Navbar scroll effect
window.addEventListener('scroll', function() {
  const navbar = document.querySelector('.navbar');
  if (window.scrollY > 50) {
    navbar.classList.add('scrolled');
  } else {
    navbar.classList.remove('scrolled');
  }
});

// Initialize
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', createBubbles);
} else {
  createBubbles();
}
</script>