<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <title>Reset Password Admin</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-md-5">
      <div class="card shadow-sm">
        <div class="card-body">
          <h4 class="mb-3">Reset Password Admin</h4>

          <div class="alert alert-warning small">
            Halaman ini hanya untuk darurat. Akses harus menggunakan <b>key</b> yang benar.
          </div>

          <?php if(validation_errors()): ?>
            <div class="alert alert-danger"><?= validation_errors(); ?></div>
          <?php endif; ?>
          <?php if($this->session->flashdata('err')): ?>
            <div class="alert alert-danger"><?= $this->session->flashdata('err'); ?></div>
          <?php endif; ?>
          <?php if($this->session->flashdata('ok')): ?>
            <div class="alert alert-success"><?= $this->session->flashdata('ok'); ?></div>
          <?php endif; ?>

          <?= form_open('admin/reset?key='.urlencode($key)); ?>
            <?= form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>

            <div class="mb-3">
              <label class="form-label">Password Baru</label>
              <input type="password" name="password" class="form-control" required>
            </div>

            <div class="mb-3">
              <label class="form-label">Ulangi Password</label>
              <input type="password" name="password2" class="form-control" required>
            </div>

            <button class="btn btn-primary w-100">Simpan Password</button>
          <?= form_close(); ?>

          <div class="text-muted small mt-3">
            Setelah berhasil, Anda akan diarahkan ke halaman login.
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
</body>
</html>
