<style>
  .products-header {
    background: linear-gradient(135deg, #00b4d8 0%, #0077b6 100%);
    padding: 2rem;
    border-radius: 20px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0, 119, 182, 0.2);
    position: relative;
    overflow: hidden;
  }
  
  .products-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -10%;
    width: 300px;
    height: 300px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
    animation: float 6s ease-in-out infinite;
  }
  
  .products-header::after {
    content: '';
    position: absolute;
    bottom: -30%;
    left: -5%;
    width: 200px;
    height: 200px;
    background: rgba(255, 255, 255, 0.08);
    border-radius: 50%;
    animation: float 8s ease-in-out infinite reverse;
  }
  
  @keyframes float {
    0%, 100% { transform: translateY(0) translateX(0); }
    50% { transform: translateY(-20px) translateX(10px); }
  }
  
  .products-header h3 {
    color: white;
    font-weight: 700;
    margin: 0;
    font-size: 1.8rem;
    position: relative;
    z-index: 1;
    display: flex;
    align-items: center;
    gap: 0.75rem;
  }
  
  .products-header h3::before {
    content: '🐠';
    font-size: 2rem;
    animation: swim 3s ease-in-out infinite;
  }
  
  @keyframes swim {
    0%, 100% { transform: translateX(0) rotateY(0deg); }
    50% { transform: translateX(10px) rotateY(180deg); }
  }
  
  .btn-add-product {
    background: white;
    color: #0077b6;
    border: none;
    padding: 0.75rem 1.75rem;
    border-radius: 50px;
    font-weight: 600;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    position: relative;
    z-index: 1;
    display: flex;
    align-items: center;
    gap: 0.5rem;
  }
  
  .btn-add-product:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    color: #0077b6;
    background: #f0f9ff;
  }
  
  .btn-add-product::before {
    content: '+';
    font-size: 1.5rem;
    font-weight: bold;
  }
  
  .alert-aqua {
    border-radius: 15px;
    border: none;
    padding: 1rem 1.5rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.08);
    position: relative;
    overflow: hidden;
  }
  
  .alert-aqua::before {
    content: '';
    position: absolute;
    left: 0;
    top: 0;
    bottom: 0;
    width: 5px;
  }
  
  .alert-success-aqua {
    background: linear-gradient(135deg, #d4f4dd 0%, #e8f8ed 100%);
    color: #0f5132;
  }
  
  .alert-success-aqua::before {
    background: linear-gradient(180deg, #06d6a0 0%, #118ab2 100%);
  }
  
  .alert-danger-aqua {
    background: linear-gradient(135deg, #ffd5d5 0%, #ffe5e5 100%);
    color: #842029;
  }
  
  .alert-danger-aqua::before {
    background: linear-gradient(180deg, #ef476f 0%, #d62828 100%);
  }
  
  .products-table-container {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    box-shadow: 0 5px 25px rgba(0, 0, 0, 0.05);
    overflow: hidden;
  }
  
  .table-aqua {
    margin: 0;
    border: none;
  }
  
  .table-aqua thead {
    background: linear-gradient(135deg, #00b4d8 0%, #0077b6 100%);
  }
  
  .table-aqua thead th {
    border: none;
    /* --- PERBAIKAN: Warna teks header menjadi gelap --- */
    color: #023e8a; /* Menggunakan biru gelap dari skema warna Anda */
    font-weight: 700;
    padding: 1.2rem 1rem;
    text-transform: uppercase;
    font-size: 0.85rem;
    letter-spacing: 0.5px;
  }
  
  .table-aqua tbody tr {
    border-bottom: 1px solid #e8f4f8;
    transition: all 0.3s ease;
  }
  
  .table-aqua tbody tr:hover {
    background: linear-gradient(90deg, #f0f9ff 0%, #ffffff 100%);
    transform: scale(1.01);
    box-shadow: 0 3px 10px rgba(0, 180, 216, 0.1);
  }
  
  .table-aqua tbody td {
    padding: 1.2rem 1rem;
    vertical-align: middle;
    border: none;
  }
  
  .row-number {
    background: linear-gradient(135deg, #00b4d8 0%, #0077b6 100%);
    color: white;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    margin: 0 auto;
    box-shadow: 0 3px 10px rgba(0, 119, 182, 0.3);
  }
  
  .product-code {
    background: linear-gradient(135deg, #e0f4f8 0%, #cceef5 100%);
    color: #023e8a;
    padding: 0.4rem 0.9rem;
    border-radius: 20px;
    font-family: 'Courier New', monospace;
    font-weight: 600;
    font-size: 0.85rem;
    display: inline-block;
    border: 2px solid #90e0ef;
    box-shadow: 0 2px 5px rgba(0, 119, 182, 0.1);
  }
  
  .product-name {
    font-weight: 600;
    color: #023e8a;
    font-size: 1rem;
  }
  
  .product-price {
    background: linear-gradient(135deg, #06d6a0 0%, #118ab2 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
    font-weight: 700;
    font-size: 1.05rem;
  }
  
  .product-description {
    color: #6c757d;
    font-size: 0.9rem;
    line-height: 1.4;
    /* Membatasi teks dalam 2 baris */
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
    text-overflow: ellipsis;
    /* --- TAMBAHAN: Memberikan ruang minimum pada kolom teks --- */
    min-width: 150px; 
  }
  
  .product-image-wrapper {
    width: 70px;
    height: 70px;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    border: 3px solid #e0f4f8;
    display: inline-block;
    position: relative;
  }
  
  .product-image-wrapper:hover {
    transform: scale(1.5);
    z-index: 1000;
    box-shadow: 0 8px 25px rgba(0, 180, 216, 0.3);
    border-color: #00b4d8;
  }
  
  .product-image {
    width: 100%;
    height: 100%;
    object-fit: cover;
  }
  
  .product-image-placeholder {
    width: 70px;
    height: 70px;
    border-radius: 15px;
    background: linear-gradient(135deg, #e0f4f8 0%, #d4eef5 100%);
    display: inline-flex;
    align-items: center;
    justify-content: center;
    color: #90e0ef;
    font-size: 1.8rem;
    border: 3px solid #cceef5;
  }
  
  .btn-action-aqua {
    padding: 0.5rem 1.2rem;
    border-radius: 25px;
    font-weight: 600;
    border: none;
    transition: all 0.3s ease;
    font-size: 0.85rem;
    display: inline-flex;
    align-items: center;
    gap: 0.4rem;
  }
  
  .btn-edit-aqua {
    background: linear-gradient(135deg, #ffd60a 0%, #ffc300 100%);
    color: #664d03;
    box-shadow: 0 3px 10px rgba(255, 193, 0, 0.3);
  }
  
  .btn-edit-aqua:hover {
    background: linear-gradient(135deg, #ffc300 0%, #ffb700 100%);
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(255, 193, 0, 0.4);
    color: #664d03;
  }
  
  .btn-delete-aqua {
    background: linear-gradient(135deg, #ef476f 0%, #d62828 100%);
    color: white;
    box-shadow: 0 3px 10px rgba(239, 71, 111, 0.3);
  }
  
  .btn-delete-aqua:hover {
    background: linear-gradient(135deg, #d62828 0%, #c1121f 100%);
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(239, 71, 111, 0.4);
    color: white;
  }
  
  .action-cell {
    display: flex;
    gap: 0.5rem;
    justify-content: center;
  }
  
  .btn-close {
    opacity: 0.5;
  }
  
  .btn-close:hover {
    opacity: 1;
  }
  
  .empty-state {
    text-align: center;
    padding: 3rem;
    color: #90e0ef;
  }
  
  .empty-state::before {
    content: '🐟';
    font-size: 4rem;
    display: block;
    margin-bottom: 1rem;
    opacity: 0.5;
  }
</style>

<div class="products-header d-flex justify-content-between align-items-center">
  <h3>Produk</h3>
  <a class="btn-add-product" href="<?= site_url('admin/produk/tambah'); ?>">
    Tambah Produk
  </a>
</div>

<?php if($this->session->flashdata('ok')): ?>
  <div class="alert alert-aqua alert-success-aqua alert-dismissible fade show" role="alert">
    <strong>✓ Berhasil!</strong> <?= $this->session->flashdata('ok'); ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
  </div>
<?php endif; ?>

<?php if($this->session->flashdata('err')): ?>
  <div class="alert alert-aqua alert-danger-aqua alert-dismissible fade show" role="alert">
    <strong>⚠ Perhatian!</strong> <?= $this->session->flashdata('err'); ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
  </div>
<?php endif; ?>

<div class="products-table-container">
  <div class="table-responsive">
    <table class="table table-aqua">
      
      <thead>
        <tr>
          <th width="80" class="text-center">#</th>
          <th>Kode</th>
          <th>Nama Produk</th>
          <th>Harga</th>
          <th>Deskripsi</th>
          <th>Keterangan</th>
          <th class="text-center">Gambar</th>
          <th width="200" class="text-center">Aksi</th>
        </tr>
      </thead>
      
      <tbody>
        <?php if(empty($items)): ?>
        <tr>
          <td colspan="8" class="empty-state">
            <strong>Belum ada produk</strong><br>
            <small>Klik tombol "+ Tambah Produk" untuk menambahkan</small>
          </td>
        </tr>
        <?php else: ?>
          <?php $no=1; foreach($items as $it): ?>
          <tr>
            <td class="text-center">
              <div class="row-number"><?= $no++; ?></div>
            </td>
            <td>
              <span class="product-code"><?= html_escape($it->kode); ?></span>
            </td>
            <td>
              <div class="product-name"><?= html_escape($it->name); ?></div>
            </td>
            <td>
              <div class="product-price">Rp <?= number_format($it->price,0,',','.'); ?></div>
            </td>
            
            <td>
              <div class="product-description">
                <?= html_escape(mb_strimwidth((string)$it->description, 0, 60, '…', 'UTF-8')); ?>
              </div>
            </td>

            <td>
              <div class="product-description">
                <?= html_escape(mb_strimwidth((string)$it->keterangan, 0, 60, '…', 'UTF-8')); ?>
              </div>
            </td>
            <td class="text-center">
              <?php if($it->image): ?>
                <div class="product-image-wrapper">
                  <img src="<?= base_url('assets/img/products/'.$it->image); ?>" 
                       alt="<?= html_escape($it->name); ?>" 
                       class="product-image">
                </div>
              <?php else: ?>
                <div class="product-image-placeholder">
                  🐠
                </div>
              <?php endif; ?>
            </td>
            <td>
              <div class="action-cell">
                <a class="btn-action-aqua btn-edit-aqua" 
                   href="<?= site_url('admin/produk/edit/'.$it->id); ?>">
                  ✏️ Edit
                </a>
                <a class="btn-action-aqua btn-delete-aqua" 
                   href="<?= site_url('admin/produk/hapus/'.$it->id); ?>" 
                   onclick="return confirm('🐠 Hapus produk ini?')">
                  🗑️ Hapus
                </a>
              </div>
            </td>
          </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>