<?php $action = isset($row) ? 'admin/produk/edit/'.$row->id : 'admin/produk/tambah'; ?>
<h3 class="mb-3"><?= isset($row)?'Edit':'Tambah'; ?> Produk</h3>

<?= form_open_multipart($action); ?>
  <?= form_hidden($this->security->get_csrf_token_name(), $this->security->get_csrf_hash()); ?>

  <div class="mb-3">
    <label class="form-label">Nama Produk</label>
    <input type="text" name="name"
           value="<?= set_value('name', isset($row)?$row->name:''); ?>"
           class="form-control" required>
    <?= form_error('name','<small class="text-danger">','</small>'); ?>
  </div>

  <div class="mb-3">
    <label class="form-label">Nomor/Kode Produk</label>
    <input type="text" name="kode"
           value="<?= set_value('kode', isset($row)?$row->kode:''); ?>"
           class="form-control" required>
    <div class="form-text">Gunakan huruf/angka/tanda penghubung (contoh: <code>SKU-001</code>).</div>
    <?= form_error('kode','<small class="text-danger">','</small>'); ?>
    <?php if($this->session->flashdata('err')): ?>
      <small class="text-danger d-block mt-1"><?= $this->session->flashdata('err'); ?></small>
    <?php endif; ?>
  </div>

  <div class="mb-3">
    <label class="form-label">Harga (Rp)</label>
    <input type="text" name="price"
           value="<?= set_value('price', isset($row)?$row->price:''); ?>"
           class="form-control" required>
    <div class="form-text">Contoh: 25.000 atau 25,000.00 — otomatis dibaca angka.</div>
    <?= form_error('price','<small class="text-danger">','</small>'); ?>
  </div>

  <div class="mb-3">
    <label class="form-label">Deskripsi</label>
    <textarea name="description" rows="4" class="form-control"><?= set_value('description', isset($row)?$row->description:''); ?></textarea>
  </div>

  <div class="mb-3">
    <label class="form-label">Keterangan</label>
    <textarea name="keterangan" rows="3" class="form-control" placeholder="Catatan tambahan (opsional)"><?= set_value('keterangan', isset($row)?$row->keterangan:''); ?></textarea>
  </div>

  <div class="mb-3">
    <label class="form-label">Gambar (wajib saat tambah, opsional saat edit)</label>
    <input type="file" name="image" class="form-control" <?= isset($row)?'':'required'; ?>>
    <?php if(isset($row) && $row->image): ?>
      <div class="mt-2">
        <img src="<?= base_url('assets/img/products/'.$row->image); ?>" style="height:80px">
      </div>
    <?php endif; ?>
    <?php if(!empty($upload_error)): ?>
      <small class="text-danger d-block mt-1"><?= $upload_error; ?></small>
    <?php endif; ?>
  </div>

  <div class="d-flex gap-2">
    <button class="btn btn-primary"><?= isset($row)?'Simpan Perubahan':'Simpan'; ?></button>
    <a class="btn btn-secondary" href="<?= site_url('admin/produk'); ?>">Kembali</a>
  </div>
<?= form_close(); ?>
