<style>
  .portfolio-header {
    background: linear-gradient(135deg, #00b4d8 0%, #0077b6 100%);
    padding: 2rem;
    border-radius: 20px;
    margin-bottom: 2rem;
    box-shadow: 0 10px 30px rgba(0, 119, 182, 0.2);
    position: relative;
    overflow: hidden;
  }
  
  .portfolio-header::before {
    content: '';
    position: absolute;
    top: -50%;
    right: -10%;
    width: 300px;
    height: 300px;
    background: rgba(255, 255, 255, 0.1);
    border-radius: 50%;
    animation: float 6s ease-in-out infinite;
  }
  
  .portfolio-header::after {
    content: '';
    position: absolute;
    bottom: -30%;
    left: -5%;
    width: 200px;
    height: 200px;
    background: rgba(255, 255, 255, 0.08);
    border-radius: 50%;
    animation: float 8s ease-in-out infinite reverse;
  }
  
  @keyframes float {
    0%, 100% { transform: translateY(0) translateX(0); }
    50% { transform: translateY(-20px) translateX(10px); }
  }
  
  .portfolio-header h3 {
    color: white;
    font-weight: 700;
    margin: 0;
    font-size: 1.8rem;
    position: relative;
    z-index: 1;
    display: flex;
    align-items: center;
    gap: 0.75rem;
  }
  
  .portfolio-header h3::before {
    content: '🐠';
    font-size: 2rem;
    animation: swim 3s ease-in-out infinite;
  }
  
  @keyframes swim {
    0%, 100% { transform: translateX(0) rotateY(0deg); }
    50% { transform: translateX(10px) rotateY(180deg); }
  }
  
  .btn-add-portfolio {
    background: white;
    color: #0077b6;
    border: none;
    padding: 0.75rem 1.75rem;
    border-radius: 50px;
    font-weight: 600;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    position: relative;
    z-index: 1;
    display: flex;
    align-items: center;
    gap: 0.5rem;
  }
  
  .btn-add-portfolio:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
    color: #0077b6;
    background: #f0f9ff;
  }
  
  .btn-add-portfolio::before {
    content: '+';
    font-size: 1.5rem;
    font-weight: bold;
  }
  
  .portfolio-table-container {
    background: white;
    border-radius: 20px;
    padding: 1.5rem;
    box-shadow: 0 5px 25px rgba(0, 0, 0, 0.05);
    overflow: hidden;
  }
  
  .table-modern {
    margin: 0;
    border: none;
  }
  
  .table-modern thead {
    background: linear-gradient(135deg, #e0f4f8 0%, #d4eef5 100%);
  }
  
  .table-modern thead th {
    border: none;
    color: #0077b6;
    font-weight: 700;
    padding: 1.2rem 1rem;
    text-transform: uppercase;
    font-size: 0.85rem;
    letter-spacing: 0.5px;
  }
  
  .table-modern tbody tr {
    border-bottom: 1px solid #e8f4f8;
    transition: all 0.3s ease;
  }
  
  .table-modern tbody tr:hover {
    background: linear-gradient(90deg, #f0f9ff 0%, #ffffff 100%);
    transform: scale(1.01);
    box-shadow: 0 3px 10px rgba(0, 180, 216, 0.1);
  }
  
  .table-modern tbody td {
    padding: 1.2rem 1rem;
    vertical-align: middle;
    border: none;
  }
  
  .row-number {
    background: linear-gradient(135deg, #00b4d8 0%, #0077b6 100%);
    color: white;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 700;
    margin: 0 auto;
    box-shadow: 0 3px 10px rgba(0, 119, 182, 0.3);
  }
  
  .portfolio-image {
    width: 80px;
    height: 80px;
    object-fit: cover;
    border-radius: 15px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease;
    border: 3px solid #e0f4f8;
  }
  
  .portfolio-image:hover {
    transform: scale(1.1);
    box-shadow: 0 6px 20px rgba(0, 180, 216, 0.3);
  }
  
  .portfolio-title {
    font-weight: 600;
    color: #023e8a;
    font-size: 1rem;
  }
  
  .portfolio-url {
    color: #0077b6;
    font-size: 0.85rem;
    text-decoration: none;
    padding: 0.4rem 0.8rem;
    background: #e0f4f8;
    border-radius: 20px;
    display: inline-block;
    transition: all 0.3s ease;
  }
  
  .portfolio-url:hover {
    background: #00b4d8;
    color: white;
  }
  
  .btn-action {
    padding: 0.5rem 1.2rem;
    border-radius: 25px;
    font-weight: 600;
    border: none;
    transition: all 0.3s ease;
    font-size: 0.85rem;
    display: inline-flex;
    align-items: center;
    gap: 0.4rem;
  }
  
  .btn-edit {
    background: linear-gradient(135deg, #ffd60a 0%, #ffc300 100%);
    color: #664d03;
    box-shadow: 0 3px 10px rgba(255, 193, 0, 0.3);
  }
  
  .btn-edit:hover {
    background: linear-gradient(135deg, #ffc300 0%, #ffb700 100%);
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(255, 193, 0, 0.4);
  }
  
  .btn-delete {
    background: linear-gradient(135deg, #ef476f 0%, #d62828 100%);
    color: white;
    box-shadow: 0 3px 10px rgba(239, 71, 111, 0.3);
  }
  
  .btn-delete:hover {
    background: linear-gradient(135deg, #d62828 0%, #c1121f 100%);
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(239, 71, 111, 0.4);
  }
  
  .action-cell {
    display: flex;
    gap: 0.5rem;
    justify-content: center;
  }
  
  .empty-state {
    text-align: center;
    padding: 3rem;
    color: #90e0ef;
  }
  
  .empty-state::before {
    content: '🐟';
    font-size: 4rem;
    display: block;
    margin-bottom: 1rem;
    opacity: 0.5;
  }
</style>

<div class="portfolio-header d-flex justify-content-between align-items-center">
  <h3>Kelola Ikan yang Laris</h3>
  <a class="btn-add-portfolio" href="<?= site_url('admin/portfolio/tambah'); ?>">
    Tambah Portfolio
  </a>
</div>

<div class="portfolio-table-container">
  <div class="table-responsive">
    <table class="table table-modern">
      <thead>
        <tr>
          <th width="80" class="text-center">#</th>
          <th>Judul</th>
          <th class="text-center">Gambar</th>
          <th>URL</th>
          <th width="200" class="text-center">Aksi</th>
        </tr>
      </thead>
      <tbody>
        <?php if(empty($items)): ?>
        <tr>
          <td colspan="5" class="empty-state">
            <strong>Belum ada portfolio</strong><br>
            <small>Klik tombol "+ Tambah Portfolio" untuk menambahkan</small>
          </td>
        </tr>
        <?php else: ?>
          <?php $no=1; foreach($items as $it): ?>
          <tr>
            <td class="text-center">
              <div class="row-number"><?= $no++; ?></div>
            </td>
            <td>
              <div class="portfolio-title"><?= html_escape($it->title); ?></div>
            </td>
            <td class="text-center">
              <?php if($it->image): ?>
                <img src="<?= base_url('assets/img/portfolio/'.$it->image); ?>" 
                     alt="<?= html_escape($it->title); ?>" 
                     class="portfolio-image">
              <?php else: ?>
                <div class="portfolio-image" style="display: flex; align-items: center; justify-content: center; background: #e0f4f8; color: #0077b6;">
                  🖼️
                </div>
              <?php endif; ?>
            </td>
            <td>
              <?php if($it->url): ?>
                <a href="<?= html_escape($it->url); ?>" 
                   target="_blank" 
                   class="portfolio-url">
                  🔗 <?= html_escape($it->url); ?>
                </a>
              <?php else: ?>
                <span style="color: #adb5bd;">-</span>
              <?php endif; ?>
            </td>
            <td>
              <div class="action-cell">
                <a class="btn-action btn-edit" 
                   href="<?= site_url('admin/portfolio/edit/'.$it->id); ?>">
                  ✏️ Edit
                </a>
                <a class="btn-action btn-delete" 
                   href="<?= site_url('admin/portfolio/hapus/'.$it->id); ?>" 
                   onclick="return confirm('🐠 Hapus portfolio ini?')">
                  🗑️ Hapus
                </a>
              </div>
            </td>
          </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>