<!doctype html>
<html lang="id">
<head>
  <meta charset="utf-8">
  <title><?= isset($title)?$title.' | ':'' ?>Admin - Aquarium Paradise</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
  
  <style>
    :root {
      --ocean-blue: #0077be;
      --aqua-green: #00bfa5;
      --deep-blue: #004d7a;
      --light-blue: #e0f7fa;
      --coral: #ff6b6b;
      --white: #ffffff;
      --sidebar-width: 280px;
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    body {
      font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
      background: linear-gradient(180deg, #e0f7fa 0%, #ffffff 100%);
      min-height: 100vh;
      overflow-x: hidden;
    }

    /* Animated Ocean Background */
    body::before {
      content: '';
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: 
        radial-gradient(circle at 20% 80%, rgba(0, 191, 165, 0.08) 0%, transparent 50%),
        radial-gradient(circle at 80% 20%, rgba(0, 119, 190, 0.08) 0%, transparent 50%);
      pointer-events: none;
      z-index: 0;
    }

    /* Bubbles Animation */
    .bubbles-container {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      pointer-events: none;
      z-index: 1;
      overflow: hidden;
    }

    .bubble {
      position: absolute;
      bottom: -100px;
      background: radial-gradient(circle at 30% 30%, rgba(255, 255, 255, 0.6), rgba(0, 191, 165, 0.3));
      border-radius: 50%;
      opacity: 0.4;
      animation: rise linear infinite;
      box-shadow: inset 0 0 10px rgba(255, 255, 255, 0.5);
    }

    @keyframes rise {
      0% {
        bottom: -100px;
        transform: translateX(0) scale(1);
        opacity: 0;
      }
      10% { opacity: 0.4; }
      50% { transform: translateX(20px) scale(1.1); }
      90% { opacity: 0.4; }
      100% {
        bottom: 110vh;
        transform: translateX(-20px) scale(0.8);
        opacity: 0;
      }
    }

    /* Admin Wrapper */
    .admin-wrapper {
      display: flex;
      min-height: 100vh;
      position: relative;
      z-index: 2;
    }

    /* Sidebar */
    .admin-sidebar {
      width: var(--sidebar-width);
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(20px);
      box-shadow: 5px 0 30px rgba(0, 119, 190, 0.15);
      position: fixed;
      left: 0;
      top: 0;
      height: 100vh;
      overflow-y: auto;
      z-index: 1000;
      transition: transform 0.3s ease;
    }

    .admin-sidebar::-webkit-scrollbar {
      width: 6px;
    }

    .admin-sidebar::-webkit-scrollbar-track {
      background: rgba(0, 119, 190, 0.05);
    }

    .admin-sidebar::-webkit-scrollbar-thumb {
      background: linear-gradient(180deg, var(--ocean-blue), var(--aqua-green));
      border-radius: 10px;
    }

    /* Brand */
    .brand {
      padding: 2rem 1.5rem;
      font-size: 1.5rem;
      font-weight: 800;
      background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
      border-bottom: 2px solid rgba(0, 191, 165, 0.2);
      position: relative;
      text-align: center;
    }

    .brand::before {
      content: '🐠';
      position: absolute;
      left: 20px;
      top: 50%;
      transform: translateY(-50%);
      animation: swimBrand 2s ease-in-out infinite;
    }

    @keyframes swimBrand {
      0%, 100% { transform: translateY(-50%); }
      50% { transform: translateY(-60%); }
    }

    /* User Info */
    .user {
      padding: 1.5rem;
      text-align: center;
      background: linear-gradient(135deg, rgba(0, 119, 190, 0.1), rgba(0, 191, 165, 0.1));
      border-radius: 15px;
      margin: 1rem;
      font-weight: 600;
      color: var(--deep-blue);
      position: relative;
      overflow: hidden;
    }

    .user::before {
      content: '👤';
      display: block;
      font-size: 2.5rem;
      margin-bottom: 0.5rem;
    }

    .user::after {
      content: '';
      position: absolute;
      top: -50%;
      left: -50%;
      width: 200%;
      height: 200%;
      background: radial-gradient(circle, rgba(255, 255, 255, 0.3) 0%, transparent 70%);
      animation: wave 8s linear infinite;
    }

    @keyframes wave {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    /* Menu */
    .menu {
      list-style: none;
      padding: 1rem 0;
      margin: 0;
    }

    .menu li {
      margin: 0.3rem 1rem;
    }

    .menu a {
      display: flex;
      align-items: center;
      padding: 1rem 1.5rem;
      color: var(--deep-blue);
      text-decoration: none;
      border-radius: 12px;
      font-weight: 600;
      transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
      position: relative;
      overflow: hidden;
    }

    .menu a::before {
      content: '';
      position: absolute;
      left: 0;
      top: 0;
      width: 4px;
      height: 100%;
      background: linear-gradient(180deg, var(--ocean-blue), var(--aqua-green));
      transform: scaleY(0);
      transition: transform 0.3s ease;
    }

    .menu a:hover {
      background: linear-gradient(135deg, rgba(0, 119, 190, 0.1), rgba(0, 191, 165, 0.1));
      transform: translateX(5px);
      box-shadow: 0 5px 15px rgba(0, 119, 190, 0.1);
    }

    .menu a:hover::before {
      transform: scaleY(1);
    }

    .menu a.active {
      background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
      color: white;
      box-shadow: 0 8px 20px rgba(0, 119, 190, 0.3);
      transform: translateX(5px);
    }

    .menu a.active::before {
      width: 100%;
      background: rgba(255, 255, 255, 0.2);
      transform: scaleY(1);
    }

    /* Main Content */
    .admin-main {
      flex: 1;
      margin-left: var(--sidebar-width);
      min-height: 100vh;
      padding: 2rem;
      position: relative;
      z-index: 2;
    }

    /* Alerts */
    .alert {
      border: none;
      border-radius: 12px;
      padding: 1rem 1.5rem;
      margin-bottom: 1.5rem;
      box-shadow: 0 5px 20px rgba(0, 0, 0, 0.1);
      backdrop-filter: blur(10px);
      animation: slideIn 0.5s ease;
    }

    @keyframes slideIn {
      from {
        opacity: 0;
        transform: translateY(-20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .alert-success {
      background: linear-gradient(135deg, rgba(0, 191, 165, 0.9), rgba(0, 191, 165, 0.7));
      color: white;
    }

    .alert-danger {
      background: linear-gradient(135deg, rgba(255, 107, 107, 0.9), rgba(255, 107, 107, 0.7));
      color: white;
    }

    /* Mobile Menu Toggle */
    .mobile-toggle {
      display: none;
      position: fixed;
      top: 1rem;
      left: 1rem;
      z-index: 1001;
      background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
      color: white;
      border: none;
      border-radius: 10px;
      padding: 0.75rem 1rem;
      font-size: 1.2rem;
      cursor: pointer;
      box-shadow: 0 5px 15px rgba(0, 119, 190, 0.3);
      transition: transform 0.3s ease;
    }

    .mobile-toggle:active {
      transform: scale(0.95);
    }

    /* Card Styles */
    .card {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(10px);
      border: 1px solid rgba(0, 191, 165, 0.2);
      border-radius: 15px;
      box-shadow: 0 10px 30px rgba(0, 119, 190, 0.1);
      transition: all 0.3s ease;
    }

    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 15px 40px rgba(0, 119, 190, 0.2);
    }

    .card-header {
      background: linear-gradient(135deg, rgba(0, 119, 190, 0.1), rgba(0, 191, 165, 0.1));
      border-bottom: 2px solid rgba(0, 191, 165, 0.2);
      font-weight: 700;
      color: var(--deep-blue);
    }

    /* Buttons */
    .btn-primary {
      background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
      border: none;
      border-radius: 10px;
      padding: 0.75rem 1.5rem;
      font-weight: 600;
      transition: all 0.3s ease;
      box-shadow: 0 5px 15px rgba(0, 119, 190, 0.3);
    }

    .btn-primary:hover {
      transform: translateY(-2px);
      box-shadow: 0 8px 25px rgba(0, 119, 190, 0.4);
    }

    /* Tables */
    .table {
      background: rgba(255, 255, 255, 0.95);
      backdrop-filter: blur(10px);
      border-radius: 12px;
      overflow: hidden;
    }

    .table thead {
      background: linear-gradient(135deg, var(--ocean-blue), var(--aqua-green));
      color: white;
    }

    .table tbody tr {
      transition: background 0.3s ease;
    }

    .table tbody tr:hover {
      background: rgba(0, 191, 165, 0.05);
    }

    /* Responsive */
    @media (max-width: 991px) {
      .mobile-toggle {
        display: block;
      }

      .admin-sidebar {
        transform: translateX(-100%);
      }

      .admin-sidebar.show {
        transform: translateX(0);
      }

      .admin-main {
        margin-left: 0;
        padding-top: 4rem;
      }

      :root {
        --sidebar-width: 280px;
      }
    }

    @media (max-width: 576px) {
      .admin-main {
        padding: 1rem;
        padding-top: 4rem;
      }

      .brand {
        font-size: 1.2rem;
        padding: 1.5rem 1rem;
      }

      .user {
        padding: 1rem;
        margin: 0.5rem;
      }

      .menu li {
        margin: 0.2rem 0.5rem;
      }

      .menu a {
        padding: 0.75rem 1rem;
        font-size: 0.9rem;
      }
    }
  </style>
</head>
<body>

<!-- Bubbles Background -->
<div class="bubbles-container" id="bubblesContainer"></div>

<!-- Mobile Toggle -->
<button class="mobile-toggle" onclick="toggleSidebar()">☰</button>

<div class="admin-wrapper">
  <aside class="admin-sidebar" id="adminSidebar">
    <div class="brand">Aquarium Admin</div>
    <div class="user"><?= html_escape($this->session->userdata('admin_name')); ?></div>
    <ul class="menu">
      <li>
      
      </li>
      <li>
        <a href="<?= site_url('admin/portfolio'); ?>"
           class="<?= ($this->uri->segment(2)=='portfolio')?'active':''; ?>">
          ⭐ Terlaris 
        </a>
      </li>
      <li>
        <a href="<?= site_url('admin/about'); ?>"
           class="<?= ($this->uri->segment(2)=='about')?'active':''; ?>">
          ℹ️ Tentang
        </a>
      </li>
      <li>
        <a href="<?= site_url('admin/produk'); ?>"
           class="<?= ($this->uri->segment(2)=='produk')?'active':''; ?>">
          🐠 Produk
        </a>
      </li>
<li>
  <a href="<?= site_url('admin/kontak'); ?>"
     class="<?= ($this->uri->segment(2)=='kontak')?'active':''; ?>">
    💬 Pesan Masuk
  </a>
</li>
      <li>

      <li>
        <a href="<?= site_url('admin/logout'); ?>" 
           style="margin-top: 2rem; background: linear-gradient(135deg, rgba(255, 107, 107, 0.1), rgba(255, 107, 107, 0.05));">
          🚪 Logout
        </a>
      </li>
    </ul>
  </aside>

  <main class="admin-main">
    <div class="container-fluid py-3 px-3 px-md-4">
      <?php if($this->session->flashdata('ok')): ?>
        <div class="alert alert-success">
          ✓ <?= $this->session->flashdata('ok'); ?>
        </div>
      <?php endif; ?>
      
      <?php if($this->session->flashdata('err')): ?>
        <div class="alert alert-danger">
          ✗ <?= $this->session->flashdata('err'); ?>
        </div>
      <?php endif; ?>

      <!-- Content dari view lainnya akan dimuat di sini -->

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
// Generate bubbles
function createBubbles() {
  const container = document.getElementById('bubblesContainer');
  const bubbleCount = 20;
  
  for (let i = 0; i < bubbleCount; i++) {
    const bubble = document.createElement('div');
    bubble.className = 'bubble';
    
    const size = Math.random() * 40 + 10;
    bubble.style.width = size + 'px';
    bubble.style.height = size + 'px';
    bubble.style.left = Math.random() * 100 + '%';
    
    const duration = (size / 10) + 10 + Math.random() * 8;
    bubble.style.animationDuration = duration + 's';
    bubble.style.animationDelay = Math.random() * 5 + 's';
    
    container.appendChild(bubble);
  }
}

// Toggle sidebar on mobile
function toggleSidebar() {
  const sidebar = document.getElementById('adminSidebar');
  sidebar.classList.toggle('show');
}

// Close sidebar when clicking outside on mobile
document.addEventListener('click', function(e) {
  if (window.innerWidth <= 991) {
    const sidebar = document.getElementById('adminSidebar');
    const toggle = document.querySelector('.mobile-toggle');
    
    if (!sidebar.contains(e.target) && !toggle.contains(e.target)) {
      sidebar.classList.remove('show');
    }
  }
});

// Initialize
if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', createBubbles);
} else {
  createBubbles();
}

// Auto-dismiss alerts after 5 seconds
setTimeout(function() {
  const alerts = document.querySelectorAll('.alert');
  alerts.forEach(alert => {
    alert.style.transition = 'opacity 0.5s ease';
    alert.style.opacity = '0';
    setTimeout(() => alert.remove(), 500);
  });
}, 5000);
</script>
</body>
</html>