<div class="card border-0 shadow-lg">
  <div class="card-header bg-light border-bottom py-4">
    <div class="d-flex align-items-center gap-3">
      <div class="bg-primary bg-opacity-10 rounded p-3" style="width: fit-content;">
        <span style="font-size: 24px;">✉️</span>
      </div>
      <div>
        <h4 class="mb-1 fw-bold text-dark">Daftar Pesan Masuk</h4>
        <p class="mb-0 text-muted small">Pesan yang dikirim melalui form kontak publik</p>
      </div>
    </div>
  </div>
  
  <div class="card-body p-4">
    <?php if(empty($messages)): ?>
      <div class="text-center py-5">
        <div class="mb-3" style="font-size: 48px;">📭</div>
        <p class="text-muted fw-500">Tidak ada pesan masuk.</p>
      </div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-hover mb-0">
          <thead class="table-light">
            <tr>
              <th class="fw-bold text-uppercase small border-bottom-2" width="50">No.</th>
              <th class="fw-bold text-uppercase small border-bottom-2">Tanggal</th>
              <th class="fw-bold text-uppercase small border-bottom-2">Nama</th>
              <th class="fw-bold text-uppercase small border-bottom-2">Email</th>
              <th class="fw-bold text-uppercase small border-bottom-2">Nomer HP</th>
              <th class="fw-bold text-uppercase small border-bottom-2">Pesan</th>
              <th class="fw-bold text-uppercase small border-bottom-2 text-center">Aksi</th>
            </tr>
          </thead>
          <tbody>
            <?php $no = 1; foreach($messages as $msg): ?>
            <tr class="align-middle" style="transition: background-color 0.2s;">
              <td class="fw-bold text-primary"><?= $no++; ?></td>
              <td>
                <small class="text-muted">
                  <?= date('d M Y', strtotime($msg->tanggal_kirim)); ?><br>
                  <span style="font-size: 12px;"><?= date('H:i', strtotime($msg->tanggal_kirim)); ?></span>
                </small>
              </td>
              <td>
                <div class="d-flex align-items-center gap-2">
                  <div class="bg-primary bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center fw-bold text-primary" style="width: 36px; height: 36px; font-size: 14px;">
                    <?= strtoupper(substr(html_escape($msg->nama), 0, 1)); ?>
                  </div>
                  <span class="fw-500"><?= html_escape($msg->nama); ?></span>
                </div>
              </td>
              <td>
                <a href="mailto:<?= html_escape($msg->email); ?>" class="text-decoration-none text-primary">
                  <small><?= html_escape($msg->email); ?></small>
                </a>
              </td>
              <td>
                <a href="tel:<?= html_escape($msg->nomer_hp); ?>" class="text-decoration-none text-muted">
                  <small><?= html_escape($msg->nomer_hp); ?></small>
                </a>
              </td>
              <td style="min-width: 250px;">
                <small class="text-muted d-block" style="line-height: 1.4; max-height: 50px; overflow: hidden; text-overflow: ellipsis;">
                  <?= nl2br(html_escape($msg->pesan)); ?>
                </small>
              </td>
              <td class="text-center">
                <a href="<?= site_url('admin/kontak/hapus/' . $msg->id); ?>" 
                   class="btn btn-outline-danger btn-sm py-1 px-3" 
                   onclick="return confirm('Apakah Anda yakin ingin menghapus pesan ini?');">
                  Hapus
                </a>
              </td>
            </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>

<style>
table tbody tr:hover {
  background-color: #f8f9ff;
}

.btn-outline-danger:hover {
  transform: translateY(-1px);
  box-shadow: 0 2px 8px rgba(220, 53, 69, 0.2);
}

.border-bottom-2 {
  border-bottom: 2px solid #dee2e6 !important;
}
</style>