<?php defined('BASEPATH') OR exit('No direct script access allowed');

class About_model extends CI_Model {

    public function get(){
        $row = $this->db->get_where('about', ['id'=>1])->row();
        if(!$row){
            $this->db->insert('about', ['id'=>1, 'content'=>'', 'address'=>'', 'phone'=>'', 'hero_image'=>NULL]);
            $row = $this->db->get_where('about', ['id'=>1])->row();
        }
        return $row;
    }

    public function upsert($data){
        return $this->db->where('id',1)->update('about', $data);
    }

    public function gallery_all(){
        return $this->db->order_by('created_at','DESC')->get('about_gallery')->result();
    }

    public function gallery_add($filename, $caption=null){
        return $this->db->insert('about_gallery', ['image'=>$filename, 'caption'=>$caption]);
    }

    public function gallery_get($id){
        return $this->db->get_where('about_gallery', ['id'=>$id])->row();
    }

    public function gallery_delete($id){
        return $this->db->delete('about_gallery', ['id'=>$id]);
    }
}
