<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Portfolio extends CI_Controller {

    public function __construct(){
        parent::__construct();
        // Wajib login
        if (!$this->session->userdata('admin_id')) {
            redirect('admin/login');
        }
        $this->load->model('Portfolio_model','portfolio');
        $this->load->helper(['url','file']);
    }

    private function render($view,$data=[]){
        $this->load->view('admin/layouts/header',$data);
        $this->load->view($view,$data);
        $this->load->view('admin/layouts/footer');
    }

    // ========================================
    // LIST
    // ========================================
    public function index(){
        $data['title'] = 'Kelola Portofolio';
        $data['items'] = $this->portfolio->all();
        $this->render('admin/portfolio_index',$data);
    }

    // ========================================
    // TAMBAH  (gambar WAJIB)
    // ========================================
    public function create(){
        $data['title'] = 'Tambah Portofolio';

        if ($this->input->method()==='post'){
            $this->form_validation->set_rules('title','Judul','required|min_length[3]');

            if (empty($_FILES['image']['name'])){
                $this->session->set_flashdata('err','Gambar wajib diupload.');
                return redirect('admin/portfolio/tambah');
            }

            if ($this->form_validation->run()){
                $insert = [
                    'title'       => html_escape($this->input->post('title',TRUE)),
                    'description' => html_escape($this->input->post('description',TRUE)),
                    'url'         => html_escape($this->input->post('url',TRUE)),
                ];

                // upload
                $config = [
                    'upload_path'   => './assets/img/portfolio/',
                    'allowed_types' => 'jpg|jpeg|png|webp',
                    'max_size'      => 4096,
                    'encrypt_name'  => TRUE,
                ];
                $this->load->library('upload', $config);

                if ($this->upload->do_upload('image')){
                    $filename = $this->upload->data('file_name');
                    // resize utama + thumbnail
                    $this->_resize_main($filename);
                    $this->_make_thumb($filename);
                    $insert['image'] = $filename;

                    $this->portfolio->insert($insert);
                    $this->session->set_flashdata('ok','Data tersimpan.');
                    return redirect('admin/portfolio');
                } else {
                    $this->session->set_flashdata('err', $this->upload->display_errors('',''));
                    return redirect('admin/portfolio/tambah');
                }
            }
        }

        $this->render('admin/portfolio_form',$data);
    }

    // ========================================
    // EDIT  (gambar OPSIONAL; jika diupload → replace & hapus lama)
    // ========================================
    public function edit($id){
        $data['title'] = 'Edit Portofolio';
        $data['row'] = $this->portfolio->get($id);
        if (!$data['row']) show_404();

        if ($this->input->method()==='post'){
            $this->form_validation->set_rules('title','Judul','required|min_length[3]');

            if ($this->form_validation->run()){
                $update = [
                    'title'       => html_escape($this->input->post('title',TRUE)),
                    'description' => html_escape($this->input->post('description',TRUE)),
                    'url'         => html_escape($this->input->post('url',TRUE)),
                ];

                // jika ada gambar baru
                if (!empty($_FILES['image']['name'])){
                    $config = [
                        'upload_path'   => './assets/img/portfolio/',
                        'allowed_types' => 'jpg|jpeg|png|webp',
                        'max_size'      => 4096,
                        'encrypt_name'  => TRUE,
                    ];
                    $this->load->library('upload', $config);

                    if ($this->upload->do_upload('image')){
                        $filename = $this->upload->data('file_name');
                        $this->_resize_main($filename);
                        $this->_make_thumb($filename);
                        $update['image'] = $filename;

                        // hapus file lama (jika ada)
                        if (!empty($data['row']->image)){
                            $this->_delete_image_files($data['row']->image);
                        }
                    } else {
                        $this->session->set_flashdata('err', $this->upload->display_errors('',''));
                        return redirect('admin/portfolio/edit/'.$id);
                    }
                }

                $this->portfolio->update($id,$update);
                $this->session->set_flashdata('ok','Perubahan disimpan.');
                return redirect('admin/portfolio');
            }
        }

        $this->render('admin/portfolio_form',$data);
    }

    // ========================================
    // HAPUS
    // ========================================
    public function delete($id){
        $row = $this->portfolio->get($id);
        if ($row){
            if (!empty($row->image)){
                $this->_delete_image_files($row->image);
            }
            $this->portfolio->delete($id);
            $this->session->set_flashdata('ok','Data dihapus.');
        }
        redirect('admin/portfolio');
    }

    // ========================================
    // UTIL: resize utama (maks 1200px)
    // ========================================
    private function _resize_main($filename){
        $source = FCPATH.'assets/img/portfolio/'.$filename;

        $config = [
            'image_library'  => 'gd2',
            'source_image'   => $source,
            'new_image'      => $source, // overwrite
            'maintain_ratio' => TRUE,
            'width'          => 1200,
            'height'         => 1200,
            'quality'        => '85%',
        ];
        $this->load->library('image_lib', $config);
        $this->image_lib->resize();
        $this->image_lib->clear();
    }

    // ========================================
    // UTIL: buat thumbnail 360x240 (crop tengah) ke file *_thumb.ext
    // ========================================
    private function _make_thumb($filename){
        $src   = FCPATH.'assets/img/portfolio/'.$filename;
        $pi    = pathinfo($src);
        $thumb = $pi['dirname'].'/'.$pi['filename'].'_thumb.'.$pi['extension'];

        // salin dulu dari source → thumb
        @copy($src, $thumb);

        // 1) resize agar salah satu sisi >= target
        $size = @getimagesize($thumb);
        if ($size){
            $w = $size[0]; $h = $size[1];
            $target_ratio = 360/240;
            $img_ratio    = ($h == 0) ? 1 : ($w / $h);

            $resize_conf = [
                'image_library'  => 'gd2',
                'source_image'   => $thumb,
                'new_image'      => $thumb,
                'maintain_ratio' => TRUE,
            ];

            if ($img_ratio > $target_ratio){
                // terlalu lebar → samakan tinggi
                $resize_conf['height'] = 240;
            } else {
                // terlalu tinggi → samakan lebar
                $resize_conf['width']  = 360;
            }
            $this->image_lib->initialize($resize_conf);
            $this->image_lib->resize();
            $this->image_lib->clear();
        }

        // 2) crop tengah ke 360x240
        $size = @getimagesize($thumb);
        if ($size){
            $w = $size[0]; $h = $size[1];
            $x = max(0, intval(($w - 360)/2));
            $y = max(0, intval(($h - 240)/2));

            $crop_conf = [
                'image_library'  => 'gd2',
                'source_image'   => $thumb,
                'new_image'      => $thumb,
                'maintain_ratio' => FALSE,
                'width'          => 360,
                'height'         => 240,
                'x_axis'         => $x,
                'y_axis'         => $y,
            ];
            $this->image_lib->initialize($crop_conf);
            $this->image_lib->crop();
            $this->image_lib->clear();
        }
    }

    // ========================================
    // UTIL: hapus file utama + thumb
    // ========================================
    private function _delete_image_files($filename){
        $main  = FCPATH.'assets/img/portfolio/'.$filename;
        $pi    = pathinfo($main);
        $thumb = $pi['dirname'].'/'.$pi['filename'].'_thumb.'.$pi['extension'];

        @unlink($main);
        @unlink($thumb);
    }
}
