<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends CI_Controller {
    public function __construct(){
        parent::__construct();
        $this->load->model('User_model','user');
        // form_validation, session, database sudah di-autoload (sesuai setup sebelumnya)
    }

    // =======================
    // LOGIN
    // =======================
    public function login(){
        if ($this->session->userdata('admin_id')) return redirect('admin');

        if ($this->input->method() === 'post'){
            $this->form_validation->set_rules('username','Username','required');
            $this->form_validation->set_rules('password','Password','required');

            if ($this->form_validation->run()){
                $u = $this->input->post('username', TRUE);
                $p = $this->input->post('password', TRUE);

                $row = $this->user->get_by_username($u);

                if ($row && password_verify($p, $row->password_hash)){
                    $this->session->set_userdata([
                        'admin_id'   => (int)$row->id,
                        'admin_name' => $row->username
                    ]);
                    return redirect('admin');
                }

                $this->session->set_flashdata('err','Username / password salah.');
                // Jangan bocorkan mana yang salah
            }
        }

        $data['title'] = 'Login Admin';
        $this->load->view('admin/auth_login', $data);
    }

    // =======================
    // LOGOUT
    // =======================
    public function logout(){
        $this->session->sess_destroy();
        redirect('admin/login');
    }

    // =======================
    // RESET PASSWORD DARURAT
    // URL: /admin/reset?key=YOUR_SECRET_KEY
    // =======================
    public function reset(){
        // Wajib pakai secret key agar tidak sembarang orang bisa reset
        $key = $this->input->get('key', TRUE);
        $expected = $this->config->item('admin_reset_key');

        if (!$expected || !$key || !hash_equals($expected, $key)){
            show_error('Forbidden: reset key salah atau belum diset.', 403);
        }

        if ($this->input->method() === 'post'){
            $this->form_validation->set_rules('password','Password Baru','required|min_length[6]');
            $this->form_validation->set_rules('password2','Konfirmasi Password','required|matches[password]');

            if ($this->form_validation->run()){
                $new = (string)$this->input->post('password', TRUE);
                $hash = password_hash($new, PASSWORD_DEFAULT);

                // Reset hanya untuk user 'admin'
                $this->db->where('username', 'admin')->update('users', ['password_hash' => $hash]);

                $this->session->set_flashdata('ok','Password admin berhasil direset. Silakan login.');
                return redirect('admin/login');
            }
        }

        $data['title'] = 'Reset Password Admin';
        $data['key']   = $key; // dipakai untuk mempertahankan ?key= di action form
        $this->load->view('admin/reset_password', $data);
    }
}
